/*
 *  SUCarbonAPI.h
 *  Sparkle
 *
 *  Created by Jack Small on 2/22/07.
 *  Copyright 2007 Jack Small. All rights reserved.
 *
 */

#ifndef SUCARBONAPI
#define SUCARBONAPI

#include <Carbon/Carbon.h>

// TLJF 12-Jun-2009 For feral prefs
#include "SUFeral.h"

enum {
	/* This HICommand is handeled automatically by Sparkle and calls SUSparkleCheckForUpdates( TRUE ); */
	kHICommandSparkleCheckForUpdates = 'sCUP',
	
	/* This HICommand is sent to the application by Sparkle before kHICommandQuit.  If your event
	   handler returns noErr the kHICommandQuit command is not sent.  */
	kHICommandSparkleQuitApplication = 'sQAP'
};

enum {
	kEventClassSparkle = 'Sprk'
};

enum {
	kEventSparkleFoundVersion = 1,
	kEventParamSparkleVersion = 'sVrs',		/* typeCFStringRef (optional) */
	kEventParamSparkleIsNew = 'sNew'		/* typeBoolean */
}; 


#ifdef __cplusplus
extern "C" {
#endif
void SUSparkleInitializeForCarbon( void )	 __attribute__((weak_import));
void SUSparkleCheckForUpdates( Boolean showUI )	 __attribute__((weak_import));
void SUSparkleCheckWithInterval( double interval )	 __attribute__((weak_import));
void SUSparkleCheckStatus( EventTargetRef theEventTarget )	 __attribute__((weak_import));
Boolean SUSparkleIsUpdateInProgress( void )	 __attribute__((weak_import));
// TLJF 19-Jan-2008 Added for Feral Interactive, Ltd.
void SUSparkleCallNSApplicationLoad(FeralGetPrefsValueFunc getPrefsFunc, FeralSetPrefsValueFunc setPrefsFunc)	 __attribute__((weak_import));
Boolean SUSparkleWillCheckForUpdates(void)	 __attribute__((weak_import));
void SUSparkleShouldCheckForUpdates(Boolean shouldCheck)	 __attribute__((weak_import));
Boolean SUSparkleAppShouldQuit(void)	 __attribute__((weak_import));
#ifdef __cplusplus
};
#endif
#endif /* SUCARBONAPI */

